
use cbodata

* Please note that the group numbers corresponds to the columns in Table 8 as follows (from left to right):

* Group 12: All households
* Group 1 : Lowest quintile
* Group 2 : Second quintile
* Group 3 : Third quintile
* Group 4 : Fourth quintile
* Group 5 : Percentile 80-90
* Group 6 : Percentile 90-95
* Group 7 : Percentile 95-99
* Group 8 : Percentile 99-100
* Group 9 : Percentile 99-99.9
* Group 10: Percentile 99.9-99.99
* Group 11: Percentile 99.99-100  

label variable lngyex "Log growth of aggregate NIPA  pre-tax, pre-transfer income excluding capital gains"
for num 1/12: label variable wagesX "Wages and salaries, group X"
for num 1/12: label variable pensX  "Pensions, group X"
for num 1/12: label variable propX "Proprietors' and other business income, group X"
for num 1/12: label variable intdivX "Interest and dividends, group X"
for num 1/12: label variable inkindX "In kind income, group X"
for num 1/12: label variable imputedtaxX "Imputed taxes, group X"
for num 1/12: label variable otherincX "Other income, group X"
for num 1/12: label variable prepreexX "Pre-tax, pre-transfer income, excl cg, group X"
for num 1/12: label variable cashtranX "Cash transfers, group X"
for num 1/12: label variable prepostexX "Pre-tax, post-transfer income, excl cg, group X"
for num 1/12: label variable cgX "Capital gains, group X"
for num 1/12: label variable prepostinX "Pre-tax, post-transfer income, incl cg, group X"
for num 1/12: label variable postpostinX "Post-tax, post-transfer income, incl cg, group X"



* TABLE 8
* =======

* First panel
* -----------

for num 12 1/11: ge rprepreexX=prepreexX/prepreex12
for num 12 1/11: ge rprepostexX=prepostexX/prepostex12
for num 12 1/11: ge rprepostinX=prepostinX/prepostin12
for num 12 1/11: ge rpostpostinX=postpostinX/postpostin12
su rprepreex*, separator(0)
su rprepostex*, separator(0)
su rprepostin*, separator(0)
su rpostpostin*, separator(0)


* Second panel
* ------------

for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX1=(X1/prepreex1)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX2=(X2/prepreex2)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX3=(X3/prepreex3)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX4=(X4/prepreex4)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX5=(X5/prepreex5)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX6=(X6/prepreex6)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX7=(X7/prepreex7)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX8=(X8/prepreex8)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX9=(X9/prepreex9)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX10=(X10/prepreex10)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX11=(X11/prepreex11)*100
for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: ge fracX12=(X12/prepreex12)*100

for any wages pens bus intdiv   inkind imputedtax otherinc cashtran cg tax postpostin: tabstat fracX12 fracX1 fracX2 fracX3 fracX4 fracX5 fracX6 fracX7 fracX8 fracX9 fracX10 fracX11, stat(mean)


* Third panel
* -----------

for num 12 1/11: ge gwagesX=ln(wagesX/wagesX[_n-1])
for num 12 1/11: ge gbusX=ln(propX+otherbusX)/(propX[_n]+otherbusX[_n-1])
for num 12 1/11: ge gintdivX=ln(intdivX/intdivX[_n-1])
for num 12 1/11: ge gcgX=ln(cgX/cgX[_n-1])
for num 12 1/11: ge gpensX=ln(pensX/pensX[_n-1])
for num 12 1/11: ge gcashtranX=ln(cashtranX/cashtranX[_n-1])
for num 12 1/11: ge ginkindX=ln(inkindX/inkindX[_n-1])
for num 12 1/11: ge gimputedtaxX=ln(imputedtaxX/imputedtaxX[_n-1])
for num 12 1/11: ge gotherincX=ln(otherincX/otherincX[_n-1])
for num 12 1/11: ge gtaxX=ln(taxX/taxX[_n-1])


reg gwages12 lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast replace
foreach num of numlist 1/11 {
reg gwages`num'   lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast 
}
seeout

reg gprepreex12 lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast replace
foreach num of numlist 1/11 {
reg gprepreex`num'   lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast 
}
seeout

reg gprepostex12 lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast replace
foreach num of numlist 1/11 {
reg gprepostex`num'  lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast 
}
seeout


reg gprepostin12 lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast replace
foreach num of numlist 1/11 {
reg gprepostin`num'  lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast 
}
seeout

reg gpostpostin12 lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast replace
foreach num of numlist 12 1/11 {
reg gpostpostin`num' lngyex0100
outreg2 lngyex0100 using table_cbo, se bdec(2) nonotes noast 
}
seeout


* Fourth panel
* ------------

ge dol12=(prepreex12-prepreex12[_n-1])/(prepreex12[_n-1])
for num 1/4: ge dolX=(prepreexX-prepreexX[_n-1])*0.2/(prepreex12[_n-1])
for num 5: ge dolX=(prepreexX-prepreexX[_n-1])*0.1/(prepreex12[_n-1])
for num 6: ge dolX=(prepreexX-prepreexX[_n-1])*0.05/(prepreex12[_n-1])
for num 7: ge dolX=(prepreexX-prepreexX[_n-1])*0.04/(prepreex12[_n-1])
for num 8: ge dolX=(prepreexX-prepreexX[_n-1])*0.01/(prepreex12[_n-1])
for num 9: ge dolX=(prepreexX-prepreexX[_n-1])*0.009/(prepreex12[_n-1])
for num 10: ge dolX=(prepreexX-prepreexX[_n-1])*0.0009/(prepreex12[_n-1])
for num 11: ge dolX=(prepreexX-prepreexX[_n-1])*0.0001/(prepreex12[_n-1])

reg dol12 gprepreex12 if inlist(year,1986,1987,1988)~=1
outreg2 gprepreex12 using table_cbo, se bdec(3) nonotes noast replace
foreach num of numlist 1/11 {
reg dol`num'   gprepreex12 if inlist(year,1986,1987,1988)~=1
outreg2 gprepreex12 using table_cbo, se bdec(3) nonotes noast 
}
seeout

ge pdol12=(postpostin12-postpostin12[_n-1])/(postpostin12[_n-1])
for num 1/4: ge pdolX=(postpostinX-postpostinX[_n-1])*0.2/(postpostin12[_n-1])
for num 5: ge pdolX=(postpostinX-postpostinX[_n-1])*0.1/(postpostin12[_n-1])
for num 6: ge pdolX=(postpostinX-postpostinX[_n-1])*0.05/(postpostin12[_n-1])
for num 7: ge pdolX=(postpostinX-postpostinX[_n-1])*0.04/(postpostin12[_n-1])
for num 8: ge pdolX=(postpostinX-postpostinX[_n-1])*0.01/(postpostin12[_n-1])
for num 9: ge pdolX=(postpostinX-postpostinX[_n-1])*0.009/(postpostin12[_n-1])
for num 10: ge pdolX=(postpostinX-postpostinX[_n-1])*0.0009/(postpostin12[_n-1])
for num 11: ge pdolX=(postpostinX-postpostinX[_n-1])*0.0001/(postpostin12[_n-1])
for num  1/11: reg pdolX gpostpostin12

reg pdol12 gpostpostin12 if inlist(year,1986,1987,1988)~=1
outreg2 gpostpostin12 using table_cbo, se bdec(3) nonotes noast replace
foreach num of numlist 1/11 {
reg pdol`num'   gpostpostin12 if inlist(year,1986,1987,1988)~=1
outreg2 gpostpostin12 using table_cbo, se bdec(3) nonotes noast 
}
seeout
